package javasposh;

import cz.cuni.pogamut.MessageObjects.Player;
import cz.cuni.pogamut.MessageObjects.Triple;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;

import cz.cuni.pogamut.MessageObjects.AddWeapon;
import cz.cuni.pogamut.MessageObjects.Ammo;
import cz.cuni.pogamut.MessageObjects.Armor;
import cz.cuni.pogamut.MessageObjects.Extra;
import cz.cuni.pogamut.MessageObjects.Health;
import cz.cuni.pogamut.MessageObjects.Item;
import cz.cuni.pogamut.MessageObjects.NavPoint;
import cz.cuni.pogamut.MessageObjects.Weapon;
import cz.cuni.sposhBot.java.JavaBehaviour;
import cz.cuni.sposhBot.java.SPoshBot;

import java.util.Collections;
import java.util.logging.Logger;
import java.util.Random;

/**
 * Here is the place to implement your acts and senses
 * The log domain of a behaviour is set to class name.
 *
 * act:
 *     in plan file: shoot
 *     in behaviour: public void action_shoot()
 * sense:
 *     in plan file: hear
 *     in behaviour: public boolean sense_hear()
 *
 * E.g. see action_doNothing() /  sense_fail()
 */
public class MyBehaviour extends JavaBehaviour {
    
    protected Item predmet_co_ho_chci = null;
    protected ArrayList<Item> predmety = new ArrayList<Item>();
    protected Player posledni_padouch = null;
    protected Player nejaky_padouch = null;  
    
    int pokusy_dohaneni = 0;
    
    Random randomGenerator = new Random();
    int vyber = 0;
   	
    public MyBehaviour(String name, Logger log, SPoshBot bot) {
        super(name, log, bot);    
                       
    }
    
    public boolean action_pal() {
        // podle possledniho padoucha
        this.log.info("AAAAAAAAAA Palim.");
        nejaky_padouch = bot.getMemory().getSeeEnemy();
        if (nejaky_padouch != null)
            posledni_padouch = nejaky_padouch;  // to je posledni videny
        else
            return false;
        pokusy_dohaneni = 0;
    	AddWeapon weapon = this.bot.getMemory().getBetterWeapon(posledni_padouch.location, this.bot.getMemory().getAgentLocation());
    	this.bot.getBody().changeWeapon(weapon);      
        this.bot.getBody().shoot(posledni_padouch);  
        return true;
    } 
    
    public boolean action_pust_to() {
        this.log.info("AAAAAAAAAA Poustim to.");
	this.bot.getBody().stopShoot();
	return true;        
    }
        
    public boolean action_uhni() {
        this.log.info("AAAAAAAAAA Uhybam.");
        // jednorazovy uhybny manevr
        // jednou prijde lingebra a bude to tu chytrejsi
        // taky by bylo hezky, aby se nepropadal => raycasting?
        vyber = randomGenerator.nextInt(5);
        if (vyber == 0)
            bot.getBody().jump();
        if (vyber == 1)
            bot.getBody().doubleJump();
        if (vyber == 2)
            bot.getBody().dodge(new Triple(0,1,0));
        if (vyber == 3)
            bot.getBody().dodge(new Triple(0,-1,0));
        if (vyber == 4)
            bot.getBody().dodge(new Triple(1,0,0));
        return true;
    }
    
    public boolean action_rozhledni_se() {
        this.log.info("AAAAAAAAAA rozhlizim se.");
        bot.getBody().turnHorizontal(45);
        bot.getBody().jump();
        return true;
    }
    
    public boolean action_dohon_ho() {
        this.log.info("AAAAAAAAAA Dohanim.");
        pokusy_dohaneni++;
        if (pokusy_dohaneni > 20) {
            pokusy_dohaneni = 0;
            posledni_padouch = null;
            return false;
        }
        Player novy_padouch = this.bot.getMemory().getSeeEnemy();
        if (novy_padouch != null){
            this.bot.getBody().shoot(novy_padouch);
            this.bot.getBody().strafeToTarget(novy_padouch, posledni_padouch.getLocation());
        }
        else
            if (! this.bot.getMap().safeRunToLocation(posledni_padouch.getLocation())){
                posledni_padouch = null;
                return false;
            }
        return true;
    }
    
    public boolean action_pohni_se_k_nemu() {
/////////////////////// //tady budem strafovat, asi na nahodna mista neo co? lingebra? items?
        this.log.info("AAAAAAAAAA Pohyb k padouchovi.");
        this.bot.getBody().doubleJump();
        this.bot.getBody().strafeToTarget(posledni_padouch, posledni_padouch.getLocation());
        
    	AddWeapon weapon = this.bot.getMemory().getBetterWeapon(posledni_padouch.location, this.bot.getMemory().getAgentLocation());
    	this.bot.getBody().changeWeapon(weapon);      
        this.bot.getBody().shoot(posledni_padouch);  
        return true;
    } 
                 
    public boolean action_uhybam() {
        this.log.info("AAAAAAAAAA Opatrne pro nejblizsi lekarnu.");
        // neco vyberu a snazim se k tomu dostat, mezitim hopkam apod.
        
        if (predmet_co_ho_chci != null && ( 10 < Triple.distanceInSpace(bot.getMemory().getAgentLocation(),predmet_co_ho_chci.location))) {
            // pokracuju, uz mam vybrano
            return true;
        }
        
        ArrayList<Item> lekarna = bot.getMap().nearestHealth(25, 1);
        if (lekarna != null && lekarna.size() > 0) {
            predmet_co_ho_chci = lekarna.get(0);
            if (nejaky_padouch != null)
                this.bot.getBody().strafeToTarget(posledni_padouch, predmet_co_ho_chci.location);
            else
                this.bot.getMap().safeRunToLocation(predmet_co_ho_chci.location);
        }
        return true;
    }
            
    
    public boolean action_neco_vyberu() {
        
        if (predmety.size() == 0){
            // vybirame poprve            
         for ( Item predmet : bot.getMemory().getKnownWeapons())
                predmety.add(predmet);
         for ( Item predmet : bot.getMemory().getKnownArmors())
                predmety.add(predmet);
         for ( Item predmet : bot.getMemory().getKnownHealths())
                predmety.add(predmet);
         //for ( Item predmet : bot.getMemory().getKnownExtras())
         //       this.predmety.add(predmet);
         for ( Item predmet : bot.getMemory().getKnownAmmos())
                predmety.add(predmet); 
        }
                
        // ze znamych veci 
        if ((predmet_co_ho_chci != null) && ( 100 < Triple.distanceInSpace(bot.getMemory().getAgentLocation(),predmet_co_ho_chci.location))) {
            this.log.info("A########### uz mam");
            return true;
        }
        
        this.log.info("AAAAAAAAAA Vybiram neco na sber. " + String.valueOf(predmety.size()));
        
        if (predmety.size() > 0)
            predmet_co_ho_chci = predmety.get(randomGenerator.nextInt(predmety.size()));
        else{
            this.log.info("A########### neni co vybrat!!!");
            return false;
        }
        return true;
    }
            
    public boolean action_seberu_to() {
        this.log.info("AAAAAAAAAA Jdu pro to co jsem vybral.");
        if (predmet_co_ho_chci == null){
            this.log.info("AAAAAAAAAA Nemam vybrano!!! - bezim nahodne");
               ArrayList<NavPoint> navy = bot.getMemory().getKnownNavPoints();
                if (navy.size() > 0){
                    vyber = randomGenerator.nextInt(navy.size());
                    predmet_co_ho_chci = new Item();
                    predmet_co_ho_chci.location = navy.get(vyber).location;
                }        
                else {
                    // zadne navpointy??
                    return false;
                }
        }

        if ( ! this.bot.getMap().safeRunToLocation(predmet_co_ho_chci.location)){
            this.log.info("AAAAAAAAAA Nejde to.");
            predmet_co_ho_chci = null;
            return false;
        }
        this.log.info("AAAAAAAAAA Jde to.");    
        
        return true;
    }
            
    public boolean action_obchuzka_po_lekarnach() {
        this.log.info("AAAAAAAAAA Obchazim lekarny.");
        
        // to je kdyz nevidim zadneho padoucha!
        posledni_padouch = null;
        
        // potrebuju vybrat?
        if (predmet_co_ho_chci == null || ( 100 > Triple.distanceInSpace(bot.getMemory().getAgentLocation(),predmet_co_ho_chci.location))) {
            this.log.info("A########### vybiram lekarnu");
        
            ArrayList<Health> lekarny = bot.getMemory().getKnownHealths();
            if (lekarny.size() > 0){
                predmet_co_ho_chci = lekarny.get(randomGenerator.nextInt(lekarny.size()));
            }
            else {
                this.log.info("AAAAAAAAAA neni zadna lekarna!");
                return false;
            }
        }
        
        if (this.bot.getMemory().getSeeAnyEnemy())
            this.bot.getBody().strafeToTarget(this.bot.getMemory().getSeeEnemy(), predmet_co_ho_chci.location);
        else
            this.bot.getMap().safeRunToLocation(predmet_co_ho_chci.location);
        return true;
    }
    
    public boolean action_nic() {  
        this.log.info("AAAAAAAAAA nic");
    	return true;
    }
    
    /*************************************
     * 
     * smysly
     * 
     *************************************/
    
    @Override
    public boolean sense_fail() {
        return false;
    }
    
    @Override
    public boolean sense_succeed() {
        return true;
    }
    
    public boolean sense_strilim() {
        this.log.info("jestlipak strilim.");
        return bot.getMemory().isShooting();
    }
    
    public boolean sense_nestrilim() {
        return ! sense_strilim();
    }    
     
    public boolean sense_je_mrtvy() {
        if (posledni_padouch != null){
            this.log.info("jestlipak je mrtvy.");
            // co kdyz ho dostal nekdo jiny???
            return posledni_padouch.getID() == bot.getMemory().getWhoAgentKilled();            
        }
        else{
            this.log.info("nebyl ani zivy.");
            return true;
        }
            
    }
    
    public boolean sense_mam_koho(){
        return (posledni_padouch != null) && ! sense_je_mrtvy();
    }

    public boolean sense_jsem_u_nej() {
        if ( 100 > Triple.distanceInSpace(bot.getMemory().getAgentLocation(),posledni_padouch.getLocation()))
        {
            this.log.info("jsem u nej blizko.");
            return true;
        }
        else{
            this.log.info("NEjsem u nej blizko.");
            return false;
        }
    }
    
    public boolean sense_jsem_pod_palbou() {
        this.log.info("jsem pod palbou.");
        return bot.getMemory().isBeingDamaged() || bot.getMemory().isProjectileComming();
    }
    
    public boolean sense_vidim_slabocha() {
        if (sense_vidim_nejakeho_padoucha()) {
            if (bot.getMemory().getPlayerScore(nejaky_padouch.getID()) < 0.7 * bot.getMemory().getAgentScore())
                // jeste by stalo za to porovnat zbrane: nejaky_padouch.getPlayerWeapon()
                return true;
        }
        return false;
    }
    
    //////////////////////////////////////////////////////////
    public boolean sense_vidim_bitku() {
        return false;
    }
            
    public boolean sense_vidim_nejakeho_padoucha() {
        nejaky_padouch = bot.getMemory().getSeeEnemy();
        if (nejaky_padouch != null){
            this.log.info("nekoho vidim.");
            return true;
        }
        else {
            this.log.info("nevidim nikoho.");
            return false;
        }
    }
    
    public boolean sense_vidim_ho() {
        
        if (bot.getMemory().getSeePlayer(posledni_padouch.getID()) != null)
        {
            this.log.info("vidim ho.");
            return true;
        }
        else
        {
            this.log.info("nevidim ho.");
            return false;
        }

    }
        
    public boolean sense_nevidim_ho() {
        return ! sense_vidim_ho();
    }
    
     public boolean sense_nevidim_zadneho_padoucha() {
        return ! sense_vidim_nejakeho_padoucha();
    }
        
    public boolean sense_padouch_vidi_me() {
        // lingebra... 
        if ( 3.14/3 > Triple.angle( Triple.subtract(bot.getMemory().getAgentLocation(),nejaky_padouch.getLocation()), Triple.rotationAsVectorUTUnits(nejaky_padouch.getPlayerRotation())))
        {
            this.log.info("Vidi mne.");
            return true;
        }
        else
            this.log.info("Nevidi mne.");
            return false;
    }
            
            
    public boolean sense_vidim_neco_uzitecneho() {
        Item puv_predm = predmet_co_ho_chci;
        if (this.bot.getMemory().getSeeAnyReachableItem()){
            // zdravi?
            Health lekarna = bot.getMemory().getSeeReachableHealth();
            ArrayList<Weapon> zbrane = bot.getMemory().getSeeReachableWeapons();
            Armor stit = bot.getMemory().getSeeReachableArmor();
            Ammo naboje = this.bot.getMemory().getSeeReachableAmmo();
            if (lekarna != null && ((this.bot.getMemory().getAgentHealth() < 80) || (lekarna.boostable))) {
                predmet_co_ho_chci = lekarna;
            }
            else if (this.bot.getMemory().getSeeAnyReachableWeapon())
                for (Weapon zbran:zbrane) {
                    if (! bot.getMemory().hasWeaponOfType(zbran.weaponType))
                        predmet_co_ho_chci = zbran; 
            }
            else if (stit != null)
                predmet_co_ho_chci = stit;
            else if ((naboje != null) && 
                this.bot.getMemory().isAmmoSuitable(naboje))
                    predmet_co_ho_chci = naboje;
        }
        
        if (predmet_co_ho_chci == puv_predm){
            this.log.info("nic jsem nenasel na sebrani.");
            return false;
        }
            
        else{
            this.log.info("neco jsem nasel na sebrani.");
            return true;
        }
    }
    
    public boolean sense_umiram() {
        this.log.info("jestlipak umiram?");
        if ((bot.getMemory().getAgentHealth() < 40 )
            ||
            ! bot.getMemory().hasAnyLoadedWeapon())
            return true;
        else
            return false;
    }
    
    public boolean sense_citim_se_slaby() {
        this.log.info("jestlipak jsem slaby?");
        if (bot.getMemory().getAgentHealth() < 70 || bot.getMemory().numberOfLoadedWeapons() < 3)
            return true;
            // nebo spatne skore bot.getMemory().allPlayersScores()
        else
            return false;
    }
    
    public boolean sense_citim_se_bozsky() {
        this.log.info("jestlipak se citim jak buh?");
        return ! sense_citim_se_slaby();
    }
    
}